%% ===================================================
%  Contour-Constrained Superpixels for Image and Video Processing
%  Code written by Se-Ho Lee (seholee@mcl.korea.ac.kr)
%  ===================================================

% Example of contour-constrained superpixels for image processing

clc
clear all
close all

%% System setting
% Piotr's Computer Vision Matlab Toolbox
addpath(genpath('toolbox'));
% Structured Edge Detection Toolbox V3.0
addpath(genpath('edges-master'));
addpath('func')
addpath('mat')

load('simple_code.mat');
load('simple_code2x2.mat');
load('simple_code4x4.mat');
%% Input Settings

%Input image
img_name = '100007.jpg';
%Input edge image (8-bit unsigned image from Holistically-Nested Edge Detection Algorithm)
edge_name = '100007.png';
%Number of superpixels for a frame
SP_num = 200;


img = imread(img_name);
edge_map = double(imread(edge_name));
edge_map = edge_map / 255;

%% Superpixel Generation
[superpixel_label] = CCSForImages( img, edge_map, SP_num,  simple_code,simple_code2x2,simple_code4x4);
