%% ===================================================
%  Contour-Constrained Superpixels for Image and Video Processing
%  Code written by Se-Ho Lee (seholee@mcl.korea.ac.kr)
%  ===================================================

% Example of contour-constrained superpixels for video processing


clc
clear all
close all


%% System setting
% Piotr's Computer Vision Matlab Toolbox
addpath(genpath('toolbox'));
% Structured Edge Detection Toolbox V3.0
addpath(genpath('edges-master'));
addpath('func')
addpath('mat')
load('simple_code.mat');
load('simple_code2x2.mat');
load('simple_code4x4.mat');


%% Input Settings
%Input image
input_dir = 'input/girl/';
%Number of superpixels for a frame
SP_num = 200;

%% Superpixel Generation
[ superpixel_label_map ] = CCSForVideos(input_dir,  SP_num,  simple_code,simple_code2x2,simple_code4x4 );
    

    
    





