%% ===================================================
%  Temporal superpixels based on proximity-weighted patch matching
%  Code written by Se-Ho Lee (seholee@mcl.korea.ac.kr)
%  ===================================================

% Example of TS-PPM for image processing

clc;
clear all;
close all;

%% System setting
% Piotr's Computer Vision Matlab Toolbox
addpath(genpath('toolbox'));
% Structured Edge Detection Toolbox V3.0
addpath(genpath('edges-master'));
addpath('func');
load('simple_code.mat');

%% Input Settings

%Input image
img = imread('29030.jpg');
%Input edge image (8-bit unsigned image from Holistically-Nested Edge Detection Algorithm)
edge_map = imread('29030.png');
edge_map = double(edge_map) / 255;
%Number of superpixels for a frame
SP_num = 200;


%% Superpixel Generation
[superpixel_label] = generateSuperpixel( img, edge_map, SP_num,  simple_code);

    




