%% ===================================================
%  Temporal superpixels based on proximity-weighted patch matching
%  Code written by Se-Ho Lee (seholee@mcl.korea.ac.kr)
%  ===================================================

% Example of TS-PPM for video processing

clc;
clear all;
close all;


%% System setting
% Piotr's Computer Vision Matlab Toolbox
addpath(genpath('toolbox'));
% Structured Edge Detection Toolbox V3.0
addpath(genpath('edges-master'));
addpath('func')

%% Input Settings
%Input image directory (jpg / bmp / png / ppm)
input_dir = 'input/parachute/';
%Number of superpixels for a frame
SP_num = 200;

%% Superpixel Generation
[ superpixel_label_map ] = generateTemporalSuperpixel( input_dir, SP_num );
    
    
        
        



